globals [ sample-car ]
turtles-own [ speed speed-limit speed-min ]

to setup
  ca
  ask patches [ setup-road ]
  setup-cars
  watch sample-car
end

to setup-road  ;; procedura prolek
  if ( pycor < 2 ) and ( pycor > -2 ) [ set pcolor white ]
end

to setup-cars
  if ( pocet-aut > world-width )
  [
    user-message (word "Na silnici je pli mnoho automobil. Snite prosm hodnotu nastaven pocet-aut pod"
                       (world-width + 1)
                       " a stisknte znovu tlatko PIPRAV. Pprava byla zastavena.")
    stop
  ]

  set-default-shape turtles "car"
  crt pocet-aut [
    set color blue
    setxy random-xcor 0
    set heading  90
    ;; nastav poten rychlost v rozmez od 0.1 do 1.0
    set speed  0.1 + random-float .9
    set speed-limit  1
    set speed-min  0
    separate-cars
  ]
  set sample-car one-of turtles
  ask sample-car [ set color red ]
end

;; Tato procedura je nutn k tomu, aby po stisknut tlatka Piprav
;; nedolo k umstn dvou aut na stejn polko
to separate-cars  ;; procedura elv
  if any? other turtles-here
    [ fd 1
      separate-cars ]
end

to go
   ;; pokud je ped tebou (vpravo) auto, srovnej s nm rychlost a trochu zpomal
  ask turtles [
    ifelse any? turtles-at 1 0
      [ set speed ([speed] of one-of turtles-at 1 0)
        slow-down-car ]
      ;; jinak zrychli
      [ speed-up-car ]
    ;; nepekrauj horn a doln rychlostn limity
    if speed < speed-min  [ set speed speed-min ]
    if speed > speed-limit   [ set speed speed-limit ]
    fd speed ]
  tick
  plot-cars
end

to slow-down-car  ;; procedura elv
  set speed speed - zpomaleni
end

to speed-up-car  ;; procedura elv
  set speed speed + zrychleni
end

to plot-cars
  set-current-plot "Rychlost aut"
  set-current-plot-pen "erven auto"
  plot [speed] of sample-car
  set-current-plot-pen "Min rychlost"
  plot min [speed] of turtles
  set-current-plot-pen "Max rychlost"
  plot max [speed] of turtles
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant numbers RED #9552950 and REC #9632612.
;
; Copyright 1997 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING
; IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant numbers REC #9814682 and REC-0126227.
; Converted from StarLogoT to NetLogo, 2001.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1997).  NetLogo Traffic Basic model.
; http://ccl.northwestern.edu/netlogo/models/TrafficBasic.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1997 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/TrafficBasic
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
23
261
725
414
25
4
13.57
1
10
1
1
1
0
1
0
1
-25
25
-4
4
1
1
1
ticks

CC-WINDOW
5
428
734
523
Command Center
0

BUTTON
36
72
108
113
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
119
73
190
113
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
36
16
240
49
pocet-aut
pocet-aut
1
41
20
1
1
NIL
HORIZONTAL

SLIDER
48
159
175
192
zpomaleni
zpomaleni
0
.099
0.026
.001
1
NIL
HORIZONTAL

SLIDER
48
123
175
156
zrychleni
zrychleni
0
.0099
0.0045
.0001
1
NIL
HORIZONTAL

PLOT
286
20
706
241
Rychlost aut
as
rychlost
0.0
300.0
0.0
1.1
true
true
PENS
"erven auto" 1.0 0 -2674135 true
"Min rychlost" 1.0 0 -13345367 true
"Max rychlost" 1.0 0 -10899396 true

MONITOR
47
203
175
248
rychlost ervenho auta
  ifelse-value any? turtles\n  [   [speed] of sample-car  ]\n  [  0 ]
3
1
11

@#$#@#$#@
CO TO JE?
-----------
Tento model simuluje pohyb automobil na dlnici. Kad auto se d jednoduchou sadou pravidel: sniuje svou rychlost, pokud ped sebou vid jin auto, a zvyuje svou rychlost, pokud ped sebou jin auto nevid.

Model ukazuje, jak se mohou vytvet dopravn zcpy i bez dopravnch nehod, rozbitch most nebo pevrcench kamion. Nen teba dn "centrln piny" k tomu, aby vznikla dopravn zcpa.

JAK MODEL OVLDAT
-------------
Kliknte na tlatko PIPRAV, kter na dlnici vytvo automobily. Nastavenm POCET-AUT je mon mnit mnostv automobil na dlnici.

Kliknutm na tlatko START zahajujete a ukonujete bh modelu. Vimnte si, e se auta pohybuj ve smyce z pravho kraje obrazovky na lev.

ZRYCHLEN umouje nastavit mru, kterou auta zvyuj svou rychlost, pokud ped nimi v dohledu nen jin auto.

Kdy se ve vhledu nkterho z aut objev jin automobil, pizpsob se idi rychlosti auta ped sebou a trochu zpomal. Mru tohoto snen rychlosti lze ovldat pomoc nastaven ZPOMALEN.

VIMNTE SI
----------------
Dopravn zcpy mohou vznikat z malch "zrodk". Automobily v modelu zanaj s nhodnou pozic a rychlost. Pokud se njak auta shluknou k sob, zanou se pohybovat pomalu, zpomaluj automobily za nimi a zpsobuj tak vznik dopravn zcpy.

Pestoe se vechna auta pohybuj smrem vped, dopravn zcpa m tendenci k pohybu opanm smrem. Toto chovn je bn u fenomnu vlny: chovn celku je asto velmi rozdln od chovn jednotlivch st, kter tento celek tvo.

V grafu jsou v prbhu simulace zachycovny nsledujc ti hodnoty:
- rychlost nejrychleji jedoucho auta (kter nepekrauje rychlostn omezen)
- rychlost nejpomaleji jedoucho auta
- rychlost sledovanho automobilu (elva 0), oznaenho ervenou barvou
Povimnte si nejen maximlnch a minimlnch hodnot, ale rovn tak promnlivosti ("trhavosti") pohybu jednotlivch aut.

Uvdomte si, e v zkladnm nastaven modelu automobily zpomaluj vrazn rychleji, ne zrychluj. To je typick pro modely dopravy. 

Dokonce i v ppad, ve kterm jsou jak pro ZRYCHLEN, tak pro ZPOMALEN zvoleny velmi nzk hodnoty, automobily mohou doshnout vysok rychlosti, jeliko jsou uveden hodnoty autm piteny nebo odeteny v kadm kole modelu.

ZKUSTE SI
--------------
V tomto modelu jsou zahrnuty ti promnn, kter ovlivuj tendenci ke vzniku dopravn zcpy: poten POCET-AUT, ZRYCHLEN a ZPOMALEN. Sledujte zkonitosti, s jakmi tyto ti nastaven ovlivn plynulost dopravy. Kter z promnnch m nejvt vliv? Dvaj tyto zkonitosti smysl? Jsou v souladu s vaimi idiskmi zkuenostmi?

Nastavte ZPOMALEN na hodnotu rovnou nule. Co se stane s tokem dopravy? Postupn zvyujte hodnotu ZPOMALEN v prbhu simulace. Pi jak hodnot dojde k naruen plynulosti dopravy? 

ROZEN MODELU
------------
Zkuste vytvoit jin pravidla pro zrychlovn a zpomalovn. Jsou zde prezentovan pravidla realistick? Jsou zde njak jin pravidla, kter by byla pesnj nebo pedstavovala lep dopravn strategie?

V relnm svt se mohou rzn vozidla chovat odlinm zpsobem. Pokuste se pidat jin pravidla nebo mnit hodnoty ZRYCHLEN\ZPOMALEN nkterm z automobil. Me jedin patn idi zpsobit dopravn zcpu? 

Asymetrie mezi zrychlenm a zpomalenm je zjednoduenou reprezentac odlinch idiskch nvyk a reakn doby idi. Dokete tyto charakteristiky explicitn zakdovat do modelu?

Jak zmny jsou teba k minimalizaci ance vzniku dopravn zcpy?

Co byste zmnili, aby dopravn zcpy vznikaly smrem vped a nikoliv smrem vzad?

Vytvote model dvouproudov dopravy.

PROGRAMOVAC ZAJMAVOSTI NETLOGA
-----------------
Graf ukazuje zrove celkov hodnoty vech aut i hodnoty jednoho konkrtnho (ervenho) automobilu, co umouje sledovat souasn zkonitosti celku i chovn jedince.

Pkazu WATCH je zde pouito k usnadnn sledovn ervenho auta.

SOUVISEJC MODELY
---------------
Traffic Grid - simuluje dopravu v silnin mce s mnoha kiovatkami.

PODKOVN A ODKAZY
-----------------------
Tento model byl pvodn vyvinut v MIT Media Lab pouitm jazyka CM StarLogo. Viz Resnick, M. (1994) "Turtles, Termites and Traffic Jams: Explorations in Massively Parallel Microworlds." Cambridge, MA: MIT Press. Adaptovn byl do jazyka StarLogoT v roce 1997 jako soust projektu Connected Mathematics Project. Adaptovno do NetLoga v roce 2001 jako soust projektu Participatory Simulations Project.

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Wilensky, U. (1997). NetLogo Traffic Basic model. http://ccl.northwestern.edu/netlogo/models/TrafficBasic. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch, uvete prosm tyto informace:  Copyright 1997 Uri Wilensky.  All rights reserved. 
Pro dal informace viz http://ccl.northwestern.edu/netlogo/models/TrafficBasic.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
setup
repeat 180 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
